/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.Operations;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class Ditherer {
    public void dither(BufferedImage input) {
        int x;
        int h = input.getHeight();
        int w = input.getWidth();
        int[][] pixel = new int[w][h];
        int y = 0;
        while (y < h) {
            x = 0;
            while (x < w) {
                Color c = new Color(input.getRGB(x, y));
                double red = (double)c.getRed() * 0.2126;
                double green = (double)c.getGreen() * 0.7152;
                double blue = (double)c.getBlue() * 0.0722;
                pixel[x][y] = (int)(red + green + blue);
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < h) {
            x = 0;
            while (x < w) {
                int newpixel;
                int oldpixel = pixel[x][y];
                int val = newpixel = 255 * this.grayscale_to_monochrome(oldpixel);
                input.setRGB(x, y, new Color(val, val, val).getRGB());
                int quant_error = oldpixel - newpixel;
                if (x < w - 1) {
                    pixel[x + 1][y] = pixel[x + 1][y] + quant_error * 7 / 16;
                }
                if (y < h - 1) {
                    if (x > 0) {
                        pixel[x - 1][y + 1] = pixel[x - 1][y + 1] + quant_error * 3 / 16;
                    }
                    pixel[x][y + 1] = pixel[x][y + 1] + quant_error * 5 / 16;
                    if (x < w - 1) {
                        pixel[x + 1][y + 1] = pixel[x + 1][y + 1] + quant_error * 1 / 16;
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private int grayscale_to_monochrome(int val) {
        return val <= 50 ? 0 : 1;
    }
}

